import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns 
from decision_company import read_csv_file, create_subplots, scatter_fig_instance, set_plot_split_title, set_layout, show_plots, save_plot

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Plot scatter plots  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
scatter_fig_instance(credit_customers_numerical, 'age', 'class_binary', axes[1, 0])  
set_plot_split_title(axes[1, 0], 'Loan Approval Rates vs. Age')  
  
scatter_fig_instance(credit_customers_numerical, 'credit_amount', 'class_binary', axes[1, 1])  
set_plot_split_title(axes[1, 1], 'Loan Approval Rates vs. Credit Amount')  
  
set_layout()  
save_plot('ref_result/scatterplot_3.png')  
show_plots()  

  